#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// all circles all the timeMod01.fsh  by  HaleyHalcyon
//https://www.shadertoy.com/view/DdSXzV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define TURN 6.283185
#define HEX(x) vec3((ivec3(x) >> ivec3(16, 8, 0)) & 255) / 255.

float smootherstep(float low, float high, float t) {
    t = (t - low) / (high - low);
    t = clamp(t, 0., 1.);
    return t * t * t * (t * (t * 6. - 15.) + 10.);
}

vec3 color(float x, float smoothing) {
    float factor = mod(floor(x * 16.) / 16., 4.0);
    float f0 = smootherstep(0., 0. + smoothing, factor);
    float f1 = smootherstep(1., 1. + smoothing, factor);
    float f2 = smootherstep(2., 2. + smoothing, factor);
    float f3 = smootherstep(3., 3. + smoothing, factor);
    return (
        HEX(0x009BE8) * (f0 - f1) +
        HEX(0xEB0072) * (f1 - f2) +
        HEX(0xfff100) * (f2 - f3) +
        HEX(0x010a31) * (f3 - f0 + 1.)
    );
}

float parity(vec2 uv) {
     return 0.375 * mod(floor(uv.x) + floor(uv.y), 2.);
}

float spiral(vec2 rt, float t) {
    return (rt.x * 10. + t) * 4.;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    float t = fract(iTime / 1.25);
    
    // why is this not a const
    float scale = iResolution.x;
    vec2 uv = (2. * fragCoord - iResolution.xy) / scale;
    uv *= 4.;
   
    vec2 uvTile0 = fract(uv + 0.5) - 0.5;
    vec2 uvTile1 = fract(uv) - 0.5;
    
    vec2 rt0 = vec2(length(uvTile0), atan(uvTile0.y, uvTile0.x) / TURN);
    vec2 rt1 = vec2(length(uvTile1), atan(uvTile1.y, uvTile1.x) / TURN);
    
    float sm00th = max(fwidth(rt0.x), fwidth(rt1.x)) * 0.75;
    
    float layer = smoothstep(-sm00th, sm00th, rt0.x - 0.5);
    
    vec3 col0 = color(
        spiral(rt0, t + parity(uv + .5)), sm00th * 48.
    );
    
    vec3 col1 = color(
        spiral(rt1, -t + 0.25 + parity(uv)), sm00th * 48.
    );
    

    // Output to screen
    fragColor = vec4(
        mix(col0, col1, layer),
        1.0
    );

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

